# --- test-voix.ps1 ---
# Comparaison de voix francophones neurales (femmes + hommes)
# Nécessite Python + edge-tts + PowerShell >7.5.4 ; ffmpeg facultatif pour assemblage (comparaison)

$base = "$env:USERPROFILE\Desktop\test-voix"
New-Item -ItemType Directory -Force -Path $base | Out-Null

$phrase = "Comme l'a dit Olivier, le prix du gratuit, c’est finalement un peu de curiosité, beaucoup de patience, et la satisfaction d’obtenir un résultat personnel, durable et sans dépendance à quelque plateforme commerciale."

$voix = @(
  # Voix féminines
  "fr-FR-DeniseNeural",
  "fr-CA-SylvieNeural",
  "fr-BE-CharlineNeural",
  "fr-FR-BrigitteNeural",
  "fr-FR-VivienneNeural",
  "fr-CH-ArianeNeural",

  # Voix masculines
  "fr-FR-HenriNeural",
  "fr-BE-GerardNeural",
  "fr-FR-ClaudeNeural",
  "fr-CA-AntoineNeural"
)

# 1) Génération des fichiers individuels
$i = 1
foreach ($v in $voix) {
  $outfile = "$base\$i-$($v).mp3"
  Write-Host "Génération : $v ..."
  python -m edge_tts --voice $v --text "$phrase" --write-media "$outfile"
  $i++
}

# 2) Assemblage avec ffmpeg (si présent)
$ffmpeg = Get-Command ffmpeg -ErrorAction SilentlyContinue
if ($ffmpeg) {
  $listfile = "$base\list.txt"
  Remove-Item $listfile -ErrorAction SilentlyContinue
  $i = 1
  foreach ($v in $voix) {
    $f = "$base\$i-$v.mp3"
    Add-Content -Path $listfile -Value ("file '"+$f+"'")
    $i++
  }
  & ffmpeg -y -f concat -safe 0 -i "$listfile" -c copy "$base\comparatif.mp3"
  Write-Host "`n Fichier final : $base\comparatif.mp3"
} else {
  Write-Host "`n ffmpeg non détecté : fichiers individuels disponibles dans $base"
}
